﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TMPro;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.SceneManagement;

public class GameOverPhase : GamePhase
{
    private int _Winner;
    public AudioSource ConfettiSource { get; private set; }

    public GameOverPhase(int winner)
    {
        //Store the winner of the game
        _Winner = winner;
    }

    public override void OnStartCurrentPhase()
    {
        //Disable the game updating and pausing, and setup the UI
        Time.timeScale = 0.0f;
        PauseMenu.CanPause = false;
        GameController.Instance.Timer.SetActive(false);
        GameController.Instance.Timer.GetComponent<Animator>().Play("TimerTick", 0, 0);
        GameController.Instance.Timer.GetComponent<Animator>().enabled = false;
        GameController.Instance.ResultScreen.SetActive(true);
        GameController.Instance.ResultScreen.GetComponent<ResultMenu>().MoveToThis(_Winner);

        if(AudioManager.Instance != null)
        {
            if (AudioManager.Instance.ConfettiAudio != null)
            {
                //We've got an audio manager and sound setup, so play the confetti audio and store the audio source so it can be stopped later
                ConfettiSource = AudioManager.Instance.PlaySFX(AudioManager.Instance.ConfettiAudio, true);
            }

            if (AudioManager.Instance.VictoryAudio != null)
            {
                //We've got an audio manager and sound setup, so play the game victory audio
                AudioManager.Instance.PlaySFX(AudioManager.Instance.VictoryAudio);
            }
        }
    }

    public override void Update()
    {

    }

    public override void OnEndCurrentPhase()
    {
        //We're moving onto a new phase now, so stop the confetti audio, reset the hider camera and blend back to the spawn
        ConfettiSource.Stop();
        GameController.Instance.HiderVirtualCamera.Follow = null;
        GameController.Instance.HiderVirtualCamera.BlendTo(GameController.Instance.SpawnVirtualCamera);
    }
}
